//
//
//

class RespawningGlass extends DeusExMover;

//var() float RespawnTime; //how long until we respawn?
//var() float RespawnStrength; //how much health do we respawn with?
var() int MinVelocityThreshold;
var ThrownProjectile OtherProjectile;
var vector SavedVelocity;
var bool bAlreadyDidDamage;

replication
{
 reliable if (Role < ROLE_Authority)
  bAlreadyDidDamage, SavedVelocity, OtherProjectile;

}

function FinishedOpening()
{
	local actor A;

	// Update sound effects.
//	PlaySound( OpenedSound, SLOT_None );
	// DEUS_EX CNN - make the sounds use SoundRadius and SoundVolume
	PlaySound( OpenedSound, SLOT_None, TransientSoundVolume*SoundVolume/255.0,, 25.0*(SoundRadius+1) );
	
	// DONT Trigger any chained movers.
	/*if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, Instigator );*/

	FinishNotify();
}

function DoClose()
{
	local actor A;

	bOpening = false;
	bDelaying = false;
	InterpolateTo( Max(0,KeyNum-1), MoveTime );
//	PlaySound( ClosingSound, SLOT_None );
	// DEUS_EX CNN - make the sounds use SoundRadius and SoundVolume
	PlaySound( ClosingSound, SLOT_None, TransientSoundVolume*SoundVolume/255.0,, 25.0*(SoundRadius+1) );
	/*if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.UnTrigger( Self, Instigator );*/
	AmbientSound = MoveAmbientSound;
        bAlreadyDidDamage = False;
}

function FinishedClosing()
{
	// Update sound effects.
//	PlaySound( ClosedSound, SLOT_None );
	// DEUS_EX CNN - make the sounds use SoundRadius and SoundVolume
	PlaySound( ClosedSound, SLOT_None, TransientSoundVolume*SoundVolume/255.0,, 25.0*(SoundRadius+1) );

	// Notify our triggering actor that we have completed.
	/*if( SavedTrigger != None )
		SavedTrigger.EndEvent();*/
	SavedTrigger = None;
	Instigator = None;
        bAlreadyDidDamage = False;
	FinishNotify(); 
}

function BlowItUp(Pawn instigatedBy)
{
 TakeDamage(MinDamageThreshold + 1, instigatedBy, Location, instigatedBy.Velocity, 'Exploded');
}

function Timer()
{
 if (OtherProjectile != None)
 {
  OtherProjectile.Velocity = SavedVelocity;   // undo wall deflection
  OtherProjectile.speed = VSize(SavedVelocity);	
 }
}

function Bump(Actor Other)
{
 if ((Other != None) && (VSize(Other.Velocity) >= MinVelocityThreshold))
 {
  TakeDamage(MinDamageThreshold + 1, Pawn(Other), Location, Other.Velocity, 'Exploded');
  Pawn(Other).TakeDamage(NumFragments * 2, Pawn(Other), Other.Location, Pawn(Other).Velocity, 'Shot');
  OtherProjectile = ThrownProjectile(Other); //added to make sure we dont bounce off!
  SavedVelocity = Other.Velocity;
  SetTimer(0.02, False);
 }
}

function TakeDamage(int Damage, Pawn EventInstigator, Vector HitLocation, Vector Momentum, name DamageType)
{
	local int i;
	local Fragment frag;
	local Actor A;
	local DeusExDecal D;
	local Vector spawnLoc;
	local ExplosionLight light;

	if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
		return;

	if ((DamageType == 'NanoVirus') || (DamageType == 'EMP'))
		return;

if ((Damage >= MinDamageThreshold) && (!bAlreadyDidDamage))
{
 bAlreadyDidDamage = True;
 forEach AllActors(Class'Actor', A, Event)
 {
  if (A != None)
  {
  A.Trigger(EventInstigator, EventInstigator);
  }
 }
	spawnLoc = Location - (PrePivot >> Rotation);
 Trigger(EventInstigator, EventInstigator);
 	for (i=0; i<NumFragments; i++)
	{
		frag = Spawn(FragmentClass,,, spawnLoc + FragmentSpread * VRand());
		if (frag != None)
		{
			frag.Instigator = EventInstigator;

			// make the last fragment just drop down so we have something to attach the sound to
			if (i == NumFragments - 1)
				frag.Velocity = vect(0,0,0);
			else
				frag.CalcVelocity(VRand(), FragmentSpread);

			frag.DrawScale = FragmentScale;
			if (FragmentTexture != None)
				frag.Skin = FragmentTexture;
			if (bFragmentTranslucent)
				frag.Style = STY_Translucent;
			if (bFragmentUnlit)
				frag.bUnlit = True;
		}
	}

	// should we draw explosion effects?
	if (bDrawExplosion)
	{
		light = Spawn(class'ExplosionLight',,, spawnLoc);
		if (FragmentSpread < 64)
		{
			Spawn(class'ExplosionSmall',,, spawnLoc);
			if (light != None)
				light.size = 2;
		}
		else if (FragmentSpread < 128)
		{
			Spawn(class'ExplosionMedium',,, spawnLoc);
			if (light != None)
				light.size = 4;
		}
		else
		{
			Spawn(class'ExplosionLarge',,, spawnLoc);
			if (light != None)
				light.size = 8;
		}
	}

	// alert NPCs that I'm breaking
	AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, FragmentSpread * 16);

	MakeNoise(2.0);
	if (frag != None)
	{
		if (NumFragments <= 5)
			frag.PlaySound(ExplodeSound1, SLOT_None, 2.0,, FragmentSpread*256);
		else
			frag.PlaySound(ExplodeSound2, SLOT_None, 2.0,, FragmentSpread*256);
	}
}
}

defaultproperties
{
     minDamageThreshold=3
     bBreakable=True
     RemoteRole=ROLE_SimulatedProxy
     MinVelocityThreshold=352
}
